from io import BytesIO
from bottle import Bottle, response, request
import shelve
import random
import mimetypes


SUBMISSION_FORM = """
<h1>File Share</h1>
<form method="POST" enctype="multipart/form-data">
    <label>File</label>
    <input name="file" type="file">
    <input type="submit">
</form>
"""
SUCCESS_MESSAGE = """
<span>Successful submission! Your link is <a href="/{path}">{path}</a>.</span>
"""

app = Bottle()
files = shelve.open("file_share.shelve")

@app.get("/")
def index():
    return SUBMISSION_FORM        

@app.post("/")
def submit():
    file = request.files.get("file")
    if file:
        io = BytesIO()
        file.save(io)
        path = random.randbytes(3).hex()
        while path in files:
            path = random.randbytes(3).hex()
        files[path] = (file.filename, io.getvalue())
        return SUCCESS_MESSAGE.format(path=path)
    else:
        response.status = 400
        return "Bad request"

@app.get("/<path>")
def follow_link(path):
    file = files.get(path)
    if file:
        filename, data = file
        response.set_header("Content-Disposition", f'attachment; filename="{filename}"')
        response.content_type = mimetypes.guess_type(filename)[0] or "application/octet-stream"
        return data
    else:
        response.status = 404
        return "Not found"

try:
    app.run()
finally:
    files.close()
