import random


def get_card_score(cur_score: int, card: str) -> int:
    if card.isdigit():
        return int(card)
    elif card == "Ace":
        if cur_score + 11 > 21:
            return 1
        else:
            return 11
    else:
        return 10

def draw_card(player: str, cur_score: int) -> int:
    card = random.choice(deck)
    score = get_card_score(cur_score, card)
    deck.remove(card)
    print("~ " + player + " drew a " + card + " worth " + str(score) + " points ~")
    return score

deck = ["2", "3", "4", "5", "6", "7", "8", "9", "10", "Ace", "Jack", "Queen", "King"] * 4
num_decks = int(input("Dealer: With how many decks are we playing? "))
deck *= num_decks
print("Dealer: Alright, let's begin!")

player_score = 0
for i in range(2):
    player_score += draw_card("Player", player_score)

while True:
    print("Dealer: Your current score is " + str(player_score) + ".")
    if player_score > 21:
        player_score = 0
        print("Dealer: That's a bust, giving you a score of 0.")
        break
    print("Dealer: What will you do? (hit or pass)")
    action = input("Player: I will ")
    if action == "hit":
        player_score += draw_card("Player", player_score)
    elif action == "pass":
        break
    else:
        print("Dealer: That's not an option.")
        continue

print("Dealer: Alright, let's see what I can do.")
dealer_score = 0
while dealer_score < 17:
    dealer_score += draw_card("Dealer", dealer_score)
print("Dealer: My current score is " + str(dealer_score) + ".")
if dealer_score > 21:
    dealer_score = 0
    print("Dealer: That's a bust, giving me a score of 0.")
if dealer_score > player_score:
    print("Dealer: My score is higher than yours. I win.")
elif dealer_score == player_score:
    print("Dealer: My score is equal to yours. We tie.")
else:
    print("Dealer: My score is less than yours. You win.")
